<?php
spl_autoload_register(function ($class) {
    // Mengubah namespace menjadi path file
    $prefix = 'TelegramBot\\Api\\';
    $baseDir = __DIR__ . '/TelegramBot/Api/';

    // Periksa apakah kelas memiliki namespace yang sesuai
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    // Dapatkan nama file
    $relativeClass = substr($class, $len);
    $file = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';

    // Sertakan file jika ada
    if (file_exists($file)) {
        require_once $file;
    }
});
