<?php
require_once 'autoload.php'; // Sertakan file autoloader
// require_once __DIR__ . '/autoload.lib.php'; // Sertakan file autoloader
date_default_timezone_set("Asia/Bangkok");

use TelegramBot\Api\BotApi;



/* function countRowsWithKeywords($filePath)
{
    // Memuat semua keyword dari file
    $keywords = file('keywords.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $keywordCounts = array_fill_keys($keywords, 0);
    
    // Buka file CSV dan hitung baris yang mengandung setiap keyword
    if (($handle = fopen($filePath, 'r')) !== false) {
        while (($row = fgetcsv($handle)) !== false) {
            // Gabungkan elemen baris CSV menjadi string
            $rowString = implode(' ', $row);
            
            foreach ($keywordCounts as $keyword => &$count) {
                // Escape keyword untuk penggunaan di preg_match (misalnya tanda petik)
                $escapedKeyword = preg_quote($keyword, '/');
                
                // Menggunakan preg_match untuk mencari keyword di dalam rowString
                if (preg_match("/\b$escapedKeyword\b/", $rowString)) {
                    $count++;
                }
            }
        }
        fclose($handle);
    }

    return $keywordCounts;
} */

function countRowsWithKeywords($filePath)
{
    // Memuat semua keyword dari file
    $keywords = file('keywords.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $keywordCounts = array_fill_keys($keywords, 0);
    
    // Membaca seluruh isi file sebagai string
    $fileContent = file_get_contents($filePath);
    
    // Loop melalui keyword dan hitung kemunculannya
    foreach ($keywordCounts as $keyword => &$count) {
        // Escape keyword untuk penggunaan di preg_match (misalnya tanda petik)
        $escapedKeyword = preg_quote($keyword, '/');
        
        // Menggunakan preg_match_all untuk menghitung keyword di dalam file content
        preg_match_all("/$escapedKeyword/", $fileContent, $matches);
        
        // Menyimpan jumlah kemunculan keyword
        $count = count($matches[0]);
    }

    return $keywordCounts;
}



function formatResults($keywordCounts)
{
    // Mengurutkan keyword berdasarkan jumlah hitung (dari yang terbanyak)
    arsort($keywordCounts);
    
    // Ambil 10 keyword teratas
    $topKeywords = array_slice($keywordCounts, 0, 10, true);

    // Memanggil fungsi formatMessage untuk menghasilkan tabel yang rapi
    $formattedMessage = formatMessage($topKeywords);

    return $formattedMessage;
}
// Fungsi untuk memformat pesan yang sudah didefinisikan sebelumnya

function wrapText($text, $maxLength = 55) {
    $wrappedText = '';
    
    // Pecah teks menjadi baris-baris dengan panjang maksimum $maxLength
    while (strlen($text) > $maxLength) {
        // Temukan batas pemotongan pada spasi atau potong pada batas panjang maksimum
        $line = substr($text, 0, $maxLength);
        $lastSpace = strrpos($line, ' ');
        
        if ($lastSpace !== false) {
            // Jika ada spasi, potong di spasi terakhir
            // $line = substr($text, 0, $lastSpace);
            $line = str_pad(substr($text, 0, $lastSpace), $maxLength, ' ', STR_PAD_RIGHT);
            // $text = substr($text, $lastSpace + 1);
            $text = str_pad(substr(substr($text, $lastSpace + 1), 0, $lastSpace), $maxLength, ' ', STR_PAD_RIGHT);
        } else {
            // Jika tidak ada spasi, potong di batas panjang maksimum
            // $text = substr($text, $maxLength);
            // $text = str_pad(substr($text, 0, $lastSpace), $maxLength, ' ', STR_PAD_RIGHT);
            $text = str_pad(substr(substr($text, $lastSpace + 1), 0, $lastSpace), $maxLength, ' ', STR_PAD_RIGHT);
        }
        
        $wrappedText .= $line . "\n";
    }
    
    // Tambahkan sisa teks yang belum diproses
    $wrappedText .= $text;
    
    return $wrappedText;
}

function formatMessage($data)
{
    $keywordColumnWidth = 50; // Lebar kolom keyword
    $totalColumnWidth = 9;    // Lebar kolom total

    $message = "Summary Error PGN Mobile " .date("d-M-Y"). "\n". "\n";
    $message .= "Total" . str_repeat(' ', $totalColumnWidth - strlen("Total")) . " | Transaction\n";
    $message .= str_repeat('=', $keywordColumnWidth + $totalColumnWidth) . "\n";
    $nom = 0;
    // Tambahkan setiap item dari data
    foreach ($data as $keyword => $total) {
        $nom = $nom+1;
        // Format agar kolom rapi dengan panjang 50 karakter
        // $formattedKeyword = str_pad($keyword, $keywordColumnWidth); 
        $formattedTotal = str_pad($total, $totalColumnWidth-3, ' ', STR_PAD_RIGHT);
        $formattedKeywordFInal = str_pad($keyword, $keywordColumnWidth, ' ', STR_PAD_RIGHT);
        // $formattedKeywordFInal = wrapText($keyword,50);
        
        // $message .= $nom.". "."$formattedKeywordFInal | $formattedTotal\n";
        $message .= $nom.". "."$formattedTotal | $formattedKeywordFInal\n";
    }

    $message .= str_repeat('-', $keywordColumnWidth + $totalColumnWidth) . "\n";

    // Hitung total keseluruhan
    $total = array_sum($data);
    // $message .= str_pad("Total", $keywordColumnWidth) . " | " . str_pad($total, $totalColumnWidth, ' ', STR_PAD_LEFT) . "\n";
    $message .= $total ." Total Error". "\n";

    return "```\n" . $message . "\n```"; // Menggunakan format Markdown untuk Telegram
}
// Lokasi sementara untuk menyimpan file yang diupload
function sendDocument($chatId, $filePath, $botToken)
{
    // URL API untuk mengirim dokumen
    $url = "https://api.telegram.org/bot$botToken/sendDocument";
    
    // Parameter untuk request POST
    $params = [
        'chat_id' => $chatId,
        'document' => new \CURLFile($filePath),
    ];
    
    // Mengirim request POST
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    $response = curl_exec($ch);
    curl_close($ch);
    
    return $response;
}


function processMessage($message) {
    $uploadDir = 'uploads/';
    $botToken = '7500037769:AAEtXFp6bg9kX0XTetp4GKyfho1beMTjqls'; // Ganti dengan token API botmu
    $bot = new BotApi($botToken);

    try {
            // Jika user mengirim file
        if (isset($message['document'])) {
            $fileId = $message['document']['file_id'];
            $chatId = $message['chat']['id'];

            // Dapatkan URL file dari Telegram API
            $fileUrl = "https://api.telegram.org/bot$botToken/getFile?file_id=$fileId";
            $fileResponse = json_decode(file_get_contents($fileUrl), true);

            if (isset($fileResponse['result']['file_path'])) {
                $bot->sendMessage($chatId, "Mohon ditunggu, data kamu segera diproses.");
                
                $filePath = $fileResponse['result']['file_path'];
                $fileDownloadUrl = "https://api.telegram.org/file/bot$botToken/$filePath";

                // Download file CSV dari Telegram
                $csvFile = file_get_contents($fileDownloadUrl);
                $localFilePath = $uploadDir . basename($filePath);
                file_put_contents($localFilePath, $csvFile);

                // Proses CSV untuk menghitung jumlah baris yang mengandung setiap keyword
                $keywordCounts = countRowsWithKeywords($localFilePath);

                // Format hasil dan kirim ke user
                $responseMessage = formatResults($keywordCounts);
                // sendMessage($chatId, "Summary Error Log PGN Mobile ".date("d-M-Y"), $botToken);
                sendMessage($chatId, $responseMessage , $botToken);



                // Path ke file font TTF (sesuaikan path jika font berada di lokasi lain)
                $fontPath = $uploadDir.'/arial.ttf';  // Pastikan font ada di path ini
                
                // Path output gambar
                $outputImagePath = 'result_image.png';
                
                // Panggil fungsi untuk membuat gambar
                // textToImage($responseMessage, $outputImagePath, $fontPath);
                // sendPhotoToTelegram($chatId, $outputImagePath, $botToken);

                // Simpan hasil lengkap ke file CSV
                $fullResultsCsv = generateFullResultsCsv($keywordCounts);
                $fullResultsFilePath = $uploadDir.'/detail_log_elastic.csv';
                file_put_contents($fullResultsFilePath, $fullResultsCsv);

                // Kirim file CSV ke user
                sendDocument($chatId, $fullResultsFilePath, $botToken);

                // Hapus file setelah diproses
                unlink($localFilePath);
                unlink($fullResultsFilePath);
            }
        }else{
            $chatId = $message['chat']['id'];
            $bot->sendMessage($chatId, "Silakan unggah file Excel untuk diproses.");

        }
            
    } catch (Exception $e) {
        // Kirim pesan error jika ada
        $bot->sendMessage($chatId, 'Error: ' . $e->getMessage());
    }

}

function generateFullResultsCsv($keywordCounts)
{
    // Menyiapkan file CSV dengan header
    $csvFile = "Transaction/endpoint,Total\n";
    
    // Format setiap baris ke CSV
    foreach ($keywordCounts as $keyword => $count) {
        // Tambahkan tanda kutip ganda di sekitar keyword dan count
        $csvFile .= '"' . str_replace('"', '""', $keyword) . '",';
        $csvFile .= '"' . str_replace('"', '""', $count) . "\"\n";
    }
    
    return $csvFile;
}

   
function sendMessage($chatId, $messageText, $botToken)
    {
        // URL API untuk mengirim pesan dengan mode markdown
        $url = "https://api.telegram.org/bot$botToken/sendMessage";
        
        // Parameter untuk request POST
        $params = [
            'chat_id' => $chatId,
            'text' => $messageText,
            'parse_mode' => 'MarkdownV2' // Menggunakan MarkdownV2 untuk format monospace
        ];
        
        // Mengirim request POST
        $options = [
            'http' => [
                'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                'method'  => 'POST',
                'content' => http_build_query($params),
            ],
        ];
        
        $context  = stream_context_create($options);
        file_get_contents($url, false, $context);
    }
    
function textToImage($text, $outputImagePath, $fontPath = 'arial.ttf', $fontSize = 12)
{
    // Tentukan ukuran gambar berdasarkan panjang teks
    $lines = explode("\n", $text);
    $width = 1000; // Lebar gambar
    $height = 20 * count($lines); // Tinggi gambar disesuaikan dengan jumlah baris
    
    // Buat gambar
    $image = imagecreatetruecolor($width, $height);
    
    // Warna background putih
    $white = imagecolorallocate($image, 255, 255, 255);
    imagefilledrectangle($image, 0, 0, $width, $height, $white);
    
    // Warna teks hitam
    $black = imagecolorallocate($image, 0, 0, 0);
    
    // Cek apakah font ada
    if (!file_exists($fontPath)) {
        die('Font not found: ' . $fontPath);
    }

    // Gambar teks pada gambar
    $y = 20;
    foreach ($lines as $line) {
        imagettftext($image, $fontSize, 0, 10, $y, $black, $fontPath, $line);
        $y += 20;
    }
    
    // Simpan gambar ke file
    imagepng($image, $outputImagePath);
    
    // Hapus gambar dari memori
    imagedestroy($image);
}

function sendPhotoToTelegram($chatId, $photoPath, $botToken)
{
    $url = "https://api.telegram.org/bot$botToken/sendPhoto";

    $post_fields = [
        'chat_id' => $chatId,
        'photo'   => new CURLFile(realpath($photoPath))
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type:multipart/form-data"]);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    $output = curl_exec($ch);
    curl_close($ch);

    return $output;
}


// $chatId = '123456789'; // Ganti dengan chat ID yang ingin dikirimi
// $botToken = 'your_bot_token'; // Ganti dengan token bot Telegram
// sendPhotoToTelegram($chatId, $outputImagePath, $botToken);

define('WEBHOOK_URL', 'https://my-site.example.com/secret-path-for-webhooks/');

if (php_sapi_name() == 'cli') {
  // if run from console, set or delete webhook
  apiRequest('setWebhook', array('url' => isset($argv[1]) && $argv[1] == 'delete' ? '' : WEBHOOK_URL));
  exit;
}


$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (!$update) {
  // receive wrong update, must not happen
  exit;
}

if (isset($update["message"])) {
  processMessage($update["message"]);
}
?>
